// GMSH script to generate the mesh for the 3d heat rod
// Documentation: https://gmsh.info/doc/texinfo/gmsh.html
// Author: Andrea Pavan
// Date: 22/12/2022


//parameters
l1 = 5.0;       //domain x size
l2 = 2.5;       //domain y size
l3 = 2.0;       //domain z size
surfaceMeshSize = 0.1;		//mesh size at the boundaries


//change geometry kernel
SetFactory("OpenCASCADE");


//-----------------------
//  geometry creation
//-----------------------

Point(1) = {(l2-l3)/2, 0, 0, surfaceMeshSize};
Point(2) = {(l2-l3)/2, -l3, 0, surfaceMeshSize};
Point(3) = {(l2-l3)/2, -l3/2, 0, surfaceMeshSize};		//circle center
Point(4) = {-(l2-l3)/2, -l3, 0, surfaceMeshSize};
Point(5) = {-(l2-l3)/2, 0, 0, surfaceMeshSize};
Point(6) = {-(l2-l3)/2, -l3/2, 0, surfaceMeshSize};		//circle center


Circle(1) = {1, 3, 2};
Line(2) = {2, 4};
Circle(3) = {4, 6, 5};
Line(4) = {5, 1};

Extrude {0, 0, l1} {Curve{1}; Curve{2}; Curve{3}; Curve{4};}

Curve Loop(5) = {12, 7, 9, 11};
Plane Surface(5) = {5};
Curve Loop(6) = {1, 2, 3, 4};
Plane Surface(6) = {6};
Surface Loop(1) = {4, 3, 2, 1, 5, 6};
Volume(1) = {1};

Physical Volume("domain", 13) = {1};
Physical Surface("bottom surface", 14) = {6};
Physical Surface("top surface", 15) = {5};
Physical Surface("lateral surface", 16) = {1, 3, 4, 2};
